/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.config;

import java.io.File;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.orecruncher.dsurround.DynamicSurroundings;
import org.orecruncher.dsurround.huds.lightlevel.LightLevelHUD;

@Mod.EventBusSubscriber(modid="dsurround", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Config {
    public static final Client CLIENT;
    private static final String CLIENT_CONFIG;
    public static final ForgeConfigSpec SPEC;

    private Config() {
    }

    private static void applyConfig() {
        DynamicSurroundings.LOGGER.setDebug((Boolean)Config.CLIENT.logging.enableLogging.get());
        DynamicSurroundings.LOGGER.setTraceMask((Integer)Config.CLIENT.logging.flagMask.get());
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        Config.applyConfig();
        DynamicSurroundings.LOGGER.debug("Loaded config file %s", configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading configEvent) {
        DynamicSurroundings.LOGGER.debug("Config file changed %s", configEvent.getConfig().getFileName());
        Config.applyConfig();
    }

    public static void setup() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, SPEC, CLIENT_CONFIG);
    }

    static {
        CLIENT_CONFIG = "dsurround" + File.separator + "dsurround" + "-client.toml";
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Client {
        public final Logging logging;
        public final LightLevel lightLevel;

        Client(@Nonnull ForgeConfigSpec.Builder builder) {
            this.logging = new Logging(builder);
            this.lightLevel = new LightLevel(builder);
        }

        public static class LightLevel {
            public final ForgeConfigSpec.EnumValue<LightLevelHUD.ColorSet> colorSet;
            public final ForgeConfigSpec.EnumValue<LightLevelHUD.Mode> mode;
            public final ForgeConfigSpec.IntValue range;
            public final ForgeConfigSpec.BooleanValue hideSafe;
            public final ForgeConfigSpec.IntValue lightSpawnThreshold;

            LightLevel(@Nonnull ForgeConfigSpec.Builder builder) {
                builder.comment("Options for configuring the Light Level HUD").push("Light Level HUD Options");
                this.colorSet = builder.comment("Coloring style to use for numbering").translation("dsurround.cfg.lightlevel.ColorSet").defineEnum("Color Set", (Enum)LightLevelHUD.ColorSet.BRIGHT);
                this.mode = builder.comment("The type of light level to display").translation("dsurround.cfg.lightlevel.Mode").defineEnum("Display Mode", (Enum)LightLevelHUD.Mode.BLOCK);
                this.range = builder.comment("Block range for light level analysis").translation("dsurround.cfg.lightlevel.Range").defineInRange("Block Range", 16, 8, 64);
                this.hideSafe = builder.comment("Do not show light level for blocks where mobs will not spawn").translation("dsurround.cfg.lightlevel.HideSafe").define("Hide Safe Blocks", false);
                this.lightSpawnThreshold = builder.comment("Light level at which mobs can spawn").translation("dsurround.cfg.lightlevel.SpawnThreshold").defineInRange("Mob Spawn Light Threshold", 7, 0, 15);
            }
        }

        public static class Logging {
            public final ForgeConfigSpec.BooleanValue enableLogging;
            public final ForgeConfigSpec.BooleanValue onlineVersionCheck;
            public final ForgeConfigSpec.IntValue flagMask;

            Logging(@Nonnull ForgeConfigSpec.Builder builder) {
                builder.comment("Defines how Sound Control logging will behave").push("Logging Options");
                this.enableLogging = builder.comment("Enables/disables debug logging of the mod").translation("dsurround.cfg.logging.EnableDebug").define("Debug Logging", false);
                this.onlineVersionCheck = builder.comment("Enables/disables display of version check information").translation("dsurround.cfg.logging.VersionCheck").define("Online Version Check Result", true);
                this.flagMask = builder.comment("Bitmask for toggling various debug traces").translation("dsurround.cfg.logging.FlagMask").defineInRange("Debug Flag Mask", 0, 0, Integer.MAX_VALUE);
                builder.pop();
            }
        }
    }

    public static class Flags {
        public static int ALLOW_LIGHTLEVEL_HUD = 1;
        public static int ALLOW_CHUNK_BORDER_HUD = 2;
    }
}

